const UI_CONFIG = {
  CONTENT_CONTAINERS: [
    'youtube-container',
    'geogebra-container',
    'geogebra3d-container',
    'webpage-container',
    'podcast-container',
    'imagen-container'
  ],
  UI_CLASSES: ['mindar-ui-overlay', 'mindar-ui-target']
};

const uiCreateTrackingOverlay = () => {
  const uiTrackingOverlay = document.createElement('div');
  uiTrackingOverlay.className = 'ui-custom-tracking-overlay';
  uiTrackingOverlay.innerHTML = '<div class="ui-tracking-square"><span></span><div class="ui-scan-line"></div></div>';
  document.body.appendChild(uiTrackingOverlay);
  return uiTrackingOverlay;
};

const uiRemoveDefaultElements = () => {
  UI_CONFIG.UI_CLASSES.forEach(cls => 
    document.querySelectorAll(`.${cls}`).forEach(el => el.remove())
  );
};

const uiIsAnyContainerActive = () => {
  return UI_CONFIG.CONTENT_CONTAINERS.some(id => {
    const container = document.getElementById(id);
    return container && container.style.display !== 'none' && container.style.display !== '';
  });
};

const uiControlVisibility = (uiTrackingOverlay, hasActiveTargets = false) => {
  const shouldShow = !hasActiveTargets && !uiIsAnyContainerActive();
  uiTrackingOverlay.style.opacity = shouldShow ? '1' : '0';
  console.log(`🔍 UI ${shouldShow ? 'mostrado' : 'oculto'}: Targets=${hasActiveTargets}, Contenedores=${uiIsAnyContainerActive()}`);
};

const uiSetupContainerObserver = (uiTrackingOverlay) => {
  const observer = new MutationObserver(() => uiControlVisibility(uiTrackingOverlay));
  UI_CONFIG.CONTENT_CONTAINERS.forEach(id => {
    const container = document.getElementById(id);
    if (container) {
      observer.observe(container, { attributes: true, attributeFilter: ['style', 'class'] });
      console.log(`👁️ Observando contenedor: ${id}`);
    }
  });
};

const uiSetupEventListeners = (uiTrackingOverlay, targets) => {
  const uiHideOverlay = () => uiControlVisibility(uiTrackingOverlay, true);
  const uiShowOverlay = () => uiControlVisibility(uiTrackingOverlay, false);

  targets.forEach(target => {
    target.addEventListener('targetFound', uiHideOverlay);
    target.addEventListener('targetLost', uiShowOverlay);
  });
};

const uiInitDebugTools = (uiTrackingOverlay) => {
  window.uiForceHideTracking = () => {
    uiTrackingOverlay.style.opacity = '0';
    console.log('🔧 UI oculto forzadamente');
  };
  window.uiForceShowTracking = () => {
    uiTrackingOverlay.style.opacity = '1';
    console.log('🔧 UI mostrado forzadamente');
  };
  window.uiCheckContainerStatus = () => {
    console.log('📊 Estado de contenedores:');
    UI_CONFIG.CONTENT_CONTAINERS.forEach(id => {
      const container = document.getElementById(id);
      const isVisible = container && container.style.display !== 'none' && container.style.display !== '';
      console.log(`  ${id}: ${isVisible ? '✅ Visible' : '❌ Oculto'}`);
    });
    console.log(`🔍 UI visible: ${uiTrackingOverlay.style.opacity === '1' ? 'SÍ' : 'NO'}`);
  };
};

document.addEventListener('DOMContentLoaded', () => {
  const uiTrackingOverlay = uiCreateTrackingOverlay();
  const scene = document.querySelector('a-scene');
  const targets = document.querySelectorAll('[mindar-image-target]');

  scene.addEventListener('renderstart', () => {
    uiTrackingOverlay.style.opacity = '1';
  });

  setInterval(uiRemoveDefaultElements, 100);
  uiSetupEventListeners(uiTrackingOverlay, targets);
  setTimeout(() => uiSetupContainerObserver(uiTrackingOverlay), 1000);
  uiInitDebugTools(uiTrackingOverlay);

  console.log('🎯 Sistema de UI activado. Funciones: uiForceHideTracking(), uiForceShowTracking(), uiCheckContainerStatus()');
});